<?php
require 'includes/functions.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$p = get_product($id);
if (!$p){ header('Location: /'); exit; }

include 'includes/header.php';

// Convert produk lama yang masih pakai "image"
if (!isset($p['images']) || !is_array($p['images'])) {
    $p['images'] = [];
    if (!empty($p['image'])) {
        $p['images'][] = $p['image'];
    }
}
?>
<style>
.product-title {
    font-size: 2rem;
    font-weight: 700;
}
.product-desc {
    font-size: 1.05rem;
    line-height: 1.6;
}
.gallery-thumb img {
    cursor: pointer;
    border: 2px solid transparent;
}
.gallery-thumb img.active {
    border-color: #0d6efd;
}
</style>

<div class="row py-4">

  <!-- GALERI -->
  <div class="col-md-6">

    <div id="productCarousel" class="carousel slide border rounded shadow-sm" data-bs-ride="carousel">
      <div class="carousel-inner">

        <?php if (!empty($p['video'])): ?>
          <div class="carousel-item active">
            <video controls class="d-block w-100 rounded" style="max-height:520px;">
              <source src="<?php echo $p['video']; ?>">
            </video>
          </div>
        <?php endif; ?>

        <?php foreach($p['images'] as $index => $img): ?>
          <div class="carousel-item <?php echo (empty($p['video']) && $index==0) ? 'active' : ''; ?>">
            <img src="<?php echo $img; ?>" class="d-block w-100 rounded" style="max-height:520px; object-fit:cover;">
          </div>
        <?php endforeach; ?>

      </div>

      <button class="carousel-control-prev" type="button" data-bs-target="#productCarousel" data-bs-slide="prev">
        <span class="carousel-control-prev-icon"></span>
      </button>
      <button class="carousel-control-next" type="button" data-bs-target="#productCarousel" data-bs-slide="next">
        <span class="carousel-control-next-icon"></span>
      </button>
    </div>

    <!-- Thumbnail -->
    <?php if (count($p['images']) > 1): ?>
    <div class="d-flex gap-2 mt-3 gallery-thumb">
      <?php foreach($p['images'] as $i => $img): ?>
        <img src="<?php echo $img; ?>" 
             onclick="jumpToSlide(<?php echo !empty($p['video']) ? $i+1 : $i; ?>)" 
             class="rounded" width="70" height="70" style="object-fit:cover;">
      <?php endforeach; ?>
    </div>
    <?php endif; ?>

  </div>

  <!-- DETAIL PRODUK -->
  <div class="col-md-6">

    <h2 class="product-title"><?php echo htmlentities($p['name']); ?></h2>

    <p class="text-muted product-desc">
      <?php echo nl2br(htmlentities($p['description'])); ?>
    </p>

    <p class="fw-bold fs-4 text-primary">
      Rp <?php echo number_format($p['price'],0,',','.'); ?>
    </p>

    <p class="text-muted mb-4">
      Stok: <?php echo isset($p['stock']) ? (int)$p['stock'] : '-'; ?>
    </p>

    <div class="mt-4 d-flex gap-2">
      <?php if (!empty($p['link'])): ?>
        <a href="visit.php?id=<?php echo $p['id']; ?>" class="btn btn-primary btn-lg px-4">
          Kunjungi
        </a>
      <?php endif; ?>

      <a href="category.php?id=<?php echo $p['category_id']; ?>" 
         class="btn btn-outline-secondary btn-lg px-4">
        Kembali
      </a>
    </div>

  </div>

</div>

<script>
function jumpToSlide(i){
  var myCarousel = document.getElementById('productCarousel');
  var carousel = bootstrap.Carousel.getInstance(myCarousel);
  carousel.to(i);
}
</script>

<?php include 'includes/footer.php'; ?>