<?php
require_once __DIR__ . '/../config.php';

function load_data(){
    $json = @file_get_contents(DATA_FILE);
    $data = json_decode($json, true);
    if (!is_array($data)) $data = ['categories'=>[], 'products'=>[]];
    return $data;
}

function save_data($data){
    $fp = fopen(DATA_FILE, 'c');
    if (!$fp) return false;
    if (flock($fp, LOCK_EX)){
        ftruncate($fp, 0);
        fwrite($fp, json_encode($data, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));
        fflush($fp);
        flock($fp, LOCK_UN);
    }
    fclose($fp);
    return true;
}

function next_id($items){
    $max = 0;
    foreach($items as $it) if (isset($it['id']) && $it['id'] > $max) $max = $it['id'];
    return $max + 1;
}

function get_category($id){
    $d = load_data();
    foreach($d['categories'] as $c) if ($c['id'] == $id) return $c;
    return null;
}

function get_product($id){
    $d = load_data();
    foreach($d['products'] as $p) if ($p['id'] == $id) return $p;
    return null;
}

function slugify($text){
    $text = preg_replace('~[^\\pL0-9]+~u', '-', $text);
    $text = trim($text, '-');
    $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);
    $text = strtolower($text);
    $text = preg_replace('~[^-a-z0-9]+~', '', $text);
    if (empty($text)) return 'n-a';
    return $text;
}

function upload_media($file){
    if (!isset($file) || $file['error'] !== UPLOAD_ERR_OK) return null;
    $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
    $allowed_images = ['jpg','jpeg','png','gif','webp','svg'];
    $allowed_videos = ['mp4','webm','ogg'];
    if (!in_array($ext, array_merge($allowed_images, $allowed_videos))) return null;
    $name = time() . '_' . bin2hex(random_bytes(6)) . '.' . $ext;
    $dest = UPLOAD_DIR . '/' . $name;
    if (move_uploaded_file($file['tmp_name'], $dest)) return 'uploads/' . $name;
    return null;
}

function delete_file_path($path){
    $full = __DIR__ . '/../' . ltrim($path, '/');
    if (file_exists($full)) @unlink($full);
}

function decrement_stock($product_id){
    $data = load_data();
    foreach($data['products'] as &$p){
        if ($p['id'] == $product_id){
            if (!isset($p['stock'])) $p['stock'] = 0;
            if ($p['stock'] <= 0) return false;
            $p['stock'] = max(0, $p['stock'] - 1);
            save_data($data);
            return true;
        }
    }
    return false;
}
?>