<?php
require 'includes/functions.php';
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$cat = get_category($id);
if (!$cat){ header('Location: /'); exit; }
$data = load_data();
include 'includes/header.php';
?>
<nav aria-label="breadcrumb"><ol class="breadcrumb mb-3"><li class="breadcrumb-item"><a href='/'>Home</a></li><li class="breadcrumb-item active"><?php echo htmlentities($cat['name']); ?></li></ol></nav>
<h2 class="mb-4"><?php echo htmlentities($cat['name']); ?></h2>
<div class="row g-4">
<?php foreach($data['products'] as $p) if ($p['category_id'] == $cat['id']): ?>
  <div class="col-12 col-md-4">
    <div class="card h-100 shadow-sm">
      <?php if (!empty($p['video'])): ?>
        <video class="w-100" muted preload="metadata" style="height:220px;object-fit:cover;"><source src="<?php echo $p['video']; ?>"></video>
      <?php else: ?>
        <img src="<?php echo $p['image']; ?>" class="w-100" style="height:220px;object-fit:cover;">
      <?php endif; ?>
      <div class="card-body d-flex flex-column">
        <h5 class="card-title"><?php echo htmlentities($p['name']); ?></h5>
        <p class="text-muted small mb-2"><?php echo htmlentities($p['description']); ?></p>
        <div class="mt-auto d-flex justify-content-between align-items-center">
          <div>
            <div class="fw-bold">Rp <?php echo number_format($p['price'],0,',','.'); ?></div>
            <div class="text-muted small">Stok: <?php echo isset($p['stock']) ? (int)$p['stock'] : '-'; ?></div>
          </div>
          <div class="d-flex flex-column">
            <a href="product.php?id=<?php echo $p['id']; ?>" class="btn btn-sm btn-outline-primary mb-2">Detail</a>
            <?php if (!empty($p['link'])): ?>
              <a href="visit.php?id=<?php echo $p['id']; ?>" class="btn btn-sm btn-primary">Kunjungi</a>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
<?php endif; ?>
</div>
<?php include 'includes/footer.php'; ?>