<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/functions.php';
if (empty($_SESSION['admin'])){ header('Location: login.php'); exit; }
$data = load_data();
$edit = null;
if (isset($_GET['edit'])) $edit = get_product((int)$_GET['edit']);
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<title>Kelola Produk</title>
</head>
<body>

<div class="container py-4">
  <a href="dashboard.php" class="btn btn-link">&larr; Dashboard</a>
  <h3>Kelola Produk</h3>

  <div class="row">

    <!-- FORM TAMBAH / EDIT PRODUK -->
    <div class="col-md-6">

<form method="post" action="save_product.php" enctype="multipart/form-data">
  <input type="hidden" name="id" value="<?php echo $edit ? $edit['id'] : ''; ?>">

  <div class="mb-2">
    <input class="form-control" name="name" placeholder="Nama produk" required 
      value="<?php echo $edit?htmlentities($edit['name']):''; ?>">
  </div>

  <div class="mb-2">
    <textarea class="form-control" name="description" rows="4" placeholder="Deskripsi"><?php
      echo $edit?htmlentities($edit['description']):'';
    ?></textarea>
  </div>

  <div class="mb-2">
    <select name="category_id" class="form-control" required>
      <option value="">-- Pilih Kategori --</option>
      <?php foreach($data['categories'] as $c): ?>
      <option value="<?php echo $c['id']; ?>" 
        <?php echo ($edit && $edit['category_id']==$c['id'])? 'selected':''; ?>>
        <?php echo htmlentities($c['name']); ?>
      </option>
      <?php endforeach; ?>
    </select>
  </div>

  <!-- MULTIPLE IMAGES -->
  <div class="mb-2">
    <label>Gambar (bisa pilih banyak):</label>
    <input type="file" name="images[]" multiple accept="image/*" class="form-control">

    <?php if ($edit && !empty($edit['images']) && is_array($edit['images'])): ?>
      <div class="mt-2 d-flex flex-wrap">
        <?php foreach ($edit['images'] as $img): ?>
          <img src="<?php echo $img; ?>" 
               style="height:80px; width:80px; object-fit:cover; border-radius:6px; margin:4px;">
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>

  <!-- VIDEO -->
  <div class="mb-2">
    <label>Video (mp4/webm)</label>
    <input type="file" name="video" class="form-control">
    <?php if ($edit && !empty($edit['video'])): ?>
      <div class="mt-2">
        <video src="<?php echo $edit['video']; ?>" style="height:80px;" muted></video>
      </div>
    <?php endif; ?>
  </div>

  <div class="mb-2">
    <label>Harga</label>
    <input type="number" name="price" class="form-control" 
      value="<?php echo $edit? (int)$edit['price'] : 0; ?>" required>
  </div>

  <div class="mb-2">
    <label>Link (optional)</label>
    <input type="text" name="link" class="form-control" 
      value="<?php echo $edit? htmlentities($edit['link']) : ''; ?>">
  </div>

  <div class="mb-2">
    <label>Stok</label>
    <input type="number" name="stock" class="form-control"
      value="<?php echo $edit? (int)$edit['stock'] : 0; ?>">
  </div>

  <button class="btn btn-success"><?php echo $edit ? 'Update' : 'Tambah Produk'; ?></button>
  <?php if ($edit): ?><a class="btn btn-secondary" href="products.php">Batal</a><?php endif; ?>

</form>

    </div>

    <!-- LIST PRODUK -->
    <div class="col-md-6">
      <table class="table table-striped">
        <thead>
          <tr>
            <th>#</th><th>Nama</th><th>Kategori</th><th>Harga</th><th>Stok</th><th>Aksi</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($data['products'] as $p): ?>
          <tr>
            <td><?php echo $p['id']; ?></td>
            <td><?php echo htmlentities($p['name']); ?></td>
            <td><?php 
              $c=get_category($p['category_id']); 
              echo $c?htmlentities($c['name']):'-'; 
            ?></td>
            <td>Rp <?php echo number_format($p['price'],0,',','.'); ?></td>
            <td><?php echo isset($p['stock'])? (int)$p['stock'] : '-'; ?></td>
            <td>
              <a class="btn btn-sm btn-outline-primary" href="?edit=<?php echo $p['id']; ?>">Edit</a>
              <a class="btn btn-sm btn-outline-danger" 
                 href="delete.php?type=product&id=<?php echo $p['id']; ?>" 
                 onclick="return confirm('Hapus?')">Hapus</a>
            </td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>

  </div>
</div>

</body>
</html>